/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.eigrp.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.process.eigrp.EIGRPNeighborTable;
import com.cisco.pt.ipc.sim.process.eigrp.EIGRPProcess;
import com.cisco.pt.ipc.sim.process.eigrp.EIGRPSummaryAddress;
import com.cisco.pt.ipc.sim.process.eigrp.EIGRPTopologyTable;
import com.cisco.pt.ipc.sim.process.routing.impl.RoutingProtocolImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class EIGRPProcessImpl
extends RoutingProtocolImpl
implements EIGRPProcess {
    public EIGRPProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public int getASNumber() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getASNumber");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getASNumber");
        }
        return returnMessage.getIntValue();
    }

    public void setKs(int k1, int k2, int k3, int k4, int k5) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setKs");
        newCall.addIntParameter(k1);
        newCall.addIntParameter(k2);
        newCall.addIntParameter(k3);
        newCall.addIntParameter(k4);
        newCall.addIntParameter(k5);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void setVariance(int variance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setVariance");
        newCall.addIntParameter(variance);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public int getVariance() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getVariance");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getVariance");
        }
        return returnMessage.getIntValue();
    }

    public void setAutoSummary(boolean bAutoSum) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setAutoSummary");
        newCall.addBoolParameter(bAutoSum);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean getAutoSummary() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAutoSummary");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getAutoSummary");
        }
        return returnMessage.getBoolValue();
    }

    public void setDefaultPassiveInt(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultPassiveInt");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean getDefaultPassiveInt() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDefaultPassiveInt");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getDefaultPassiveInt");
        }
        return returnMessage.getBoolValue();
    }

    public void setPassiveInt(String portName, boolean bPassive) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPassiveInt");
        newCall.addStringParameter(portName);
        newCall.addBoolParameter(bPassive);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isPassiveInt(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isPassiveInt");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.isPassiveInt");
        }
        return returnMessage.getBoolValue();
    }

    public void setIntAdminDistance(int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setIntAdminDistance");
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void setExtAdminDistance(int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setExtAdminDistance");
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void addConfiguredNetwork(IPAddress ipAddress, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addConfiguredNetwork");
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void removeConfiguredNetwork(IPAddress ipAddress, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeConfiguredNetwork");
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public int getConfiguredNetworkCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfiguredNetworkCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getConfiguredNetworkCount");
        }
        return returnMessage.getIntValue();
    }

    public boolean addSummaryAddress(String portName, IPAddress ipAddress, IPAddress subnet, int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addSummaryAddress");
        newCall.addStringParameter(portName);
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(subnet);
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.addSummaryAddress");
        }
        return returnMessage.getBoolValue();
    }

    public boolean removeSummaryAddress(String portName, IPAddress ipAddress, IPAddress subnet, int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeSummaryAddress");
        newCall.addStringParameter(portName);
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(subnet);
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.removeSummaryAddress");
        }
        return returnMessage.getBoolValue();
    }

    public int getSummaryAddressCount(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSummaryAddressCount");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: EIGRPProcessImpl.getSummaryAddressCount");
        }
        return returnMessage.getIntValue();
    }

    public EIGRPSummaryAddress getSummaryAddressAt(String portName, int as, int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSummaryAddressAt");
        newCall.addStringParameter(portName);
        newCall.addIntParameter(as);
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (EIGRPSummaryAddress)returnMessage.getObjectValue();
    }

    public EIGRPTopologyTable getTopologyTable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTopologyTable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (EIGRPTopologyTable)returnMessage.getObjectValue();
    }

    public EIGRPNeighborTable getNeighborTable() {
        return this.getFactory().getNeighborTable(this);
    }
}

